// This is System management System Script

jQuery(function () {
   console.log('Welcome to worrdpress list table! ');
   jQuery("#deactivate-books-management-system").on("click", function (event) {
      // body...
      event.preventDefault();
      var hasConfirm = confirm("Are you sure you want to deactivate the plugin?");
      // cancel -> false
      // ok -> true
      if (hasConfirm) {
         var deactivateLink = jQuery(this).attr("href");
         window.location.href = deactivateLink;
      }

   })

   // form validation

   jQuery("#add-book-form").validate();

   // upload media file start
   jQuery("#btn-upload-profile").on("click", function (event) {
      event.preventDefault();
      // media object
      var mediaUploader = wp.media({
         title: "Upload User Profile Image",
         multiple: false
      });
      // open media uploader
      mediaUploader.open();
      // cover image file selection
      mediaUploader.on("select", function () {
         var attachment = mediaUploader.state().get("selection").first().toJSON();
         // console.log(attachment);
         jQuery("#cover_image").val(attachment.url);
      });

   });


   // Create Quick Edit functio for table
   var existingRowData = "";
   jQuery(document).on("click", ".btn-quick-edit", function () {
      if(jQuery(".btn-quick-cancel").length > 0){
         jQuery(".btn-quick-cancel").trigger("click");
      }
   var book_author = jQuery(this).parents("tr").find(".bms-book-author").text();
   var book_name = jQuery(this).parents("tr").find(".bms-name").text();
   var book_cost = jQuery(this).parents("tr").find(".bms-book_price").text();
   var book_id = jQuery(this).parents("tr").find(".bms-id").text();


let editHTMLData = `
<td colspan="9">

    <table>
    	<tr>
			<td colspan="2">Quick Edit</td>
    	</tr>
        <tr>
            <td>Book Name</td>
            <td><input type="text" class="bms-book-name" value="`+ book_name +`" name="book_name" /></td>
        </tr>
        <tr>
            <td>Author Name</td>
            <td><input type="text" class="bms-book-author" value="`+ book_author +`" name="book_author" /></td>
        </tr>
        <tr>
            <td>Book Cost</td>
            <td><input type="text" class="bms-book-cost" value="`+ book_cost +`" name="book_cost" /></td>
        </tr>
        <tr>
            <td><button data-id="`+ book_id +`" type="button" class="button button-primary save btn-save-quick-edit">Update</button></td>
            <td><button type="button" class="button cancel btn-quick-cancel">Cancel</button></td>
        </tr>
    </table>
</td>

`;
      existingRowData = jQuery(this).parents("tr").html();
      jQuery(this).parents("tr").html(editHTMLData);
      // console.log(existingRowData);
   });
   // close quick edit form on click cancel button
   jQuery(document).on("click", ".btn-quick-cancel", function () {
      jQuery(this).parents("tr").html(existingRowData);
      existingRowData = "";
   });

   // ajax request for quick edit
   jQuery(document).on("click", ".btn-save-quick-edit", function () {
   let book_name = jQuery(this).parents("tr").find(".bms-book-name").val();
   let book_author = jQuery(this).parents("tr").find(".bms-book-author").val();
   let book_cost = jQuery(this).parents("tr").find(".bms-book-cost").val();
   let book_id = jQuery(this).attr("data-id");


      // console.log(book_name, book_author, book_cost);
      // return false;

      jQuery.ajax({
         // url: bms_plugin_ajax_url.ajax_url,
         url: bms_plugin_ajax_url,
         type: "post",
         data: {
            "name": book_name,
            "author": book_author,
            "cost": book_cost,
            "id": book_id,
            "action": "bms_action",
            "param": "save_quick_form",
         },
         method:"POST",
         success: function (response) {
            console.log(response);
            location.reload();
         }
      });

   })

});