<?php

/*
 * Plugin name: Books Management System
 * Description: This is simple plugin for Books Management System learning
 * Author: Tejveer Singh (Online Web Tutor)
 * Version: 1.0
 * Text Domain: books-management-system
 * Domain Path: /languages
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Required PHP: 7.0
 *Required at least: 6.0
 */

//  define('ABSPATH', dirname(__FILE__) . '/');


 // Constants
define("BMS_PLUGIN_PATH", plugin_dir_path(__FILE__));
define("BMS_PLUGIN_URL", plugin_dir_url(__FILE__));
define("BMS_PLUGIN_BASENAME", plugin_basename(__FILE__));

// Includes
include_once BMS_PLUGIN_PATH . 'class/BooksManagement.php';
// include_once BMS_PLUGIN_PATH . 'includes/bms-book-post-type.php';
// include_once BMS_PLUGIN_PATH . 'includes/bms-book-meta-box.php';
// include_once BMS_PLUGIN_PATH . 'includes/bms-book-shortcode.php';

$booksManagementObj = new BooksManagement();

register_activation_hook(__FILE__, array($booksManagementObj, 'bmsCreateTable'));

// register deactivation hook
register_deactivation_hook(__FILE__, array($booksManagementObj, 'bmsDropTable'));

// To work with ajax request
add_action('wp_ajax_bms_action', array($booksManagementObj, 'bms_handle_ajax_request'));
