<?php

if (!class_exists('WP_List_Table')) {
    include_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

class booksListTable extends WP_List_Table
{

    public function prepare_items()
    {
        global $wpdb;
        // echo $this->current_action();
        $tablePrefix = $wpdb->prefix;
        $per_page = 10;

        // Order by
        $orderBy = isset($_GET['orderby']) ? $_GET['orderby'] : 'id';
        $order = isset($_GET['order']) ? $_GET['order'] : 'ASC';
        //Search Keywords
        $search = isset($_GET['s']) ? $_GET['s'] : false;

        $current_page = $this->get_pagenum();
        $offset = ($current_page - 1) * $per_page;

        $rowAction = $this->current_action();
        if (!empty($rowAction)) {
            $this->process_row_action($rowAction);
        }
        // ( 2 - 1 ) * 4
        // 1 + 4 = 4

        $this->_column_headers = array(
            $this->get_columns(), [],
            $this->get_shortable_columns()
        );

        if ($search) {    // Search value is available
            // Total number of books
            $totalBooks = $wpdb->get_results("SELECT * FROM {$tablePrefix}books_system WHERE name LIKE '%{$search}%' OR author LIKE '%{$search}%'", ARRAY_A);
            // Books on limits
            $books = $wpdb->get_results(
                "
        SELECT * FROM {$tablePrefix}books_system
        WHERE name LIKE '%{$search}%' OR author LIKE '%{$search}%'
        ORDER BY {$orderBy} {$order}
        LIMIT {$offset}, {$per_page}",
                ARRAY_A
            );

            $totalBooksItems = count($totalBooks);
        } else {
            $isTracedCondition = "";
            if ($rowAction == "show_all") {

            } elseif ($rowAction == "show_published") {
                $isTracedCondition = "WHERE is_trash = 0";
            } elseif ($rowAction == "show_trash") {
                $isTracedCondition = "WHERE is_trash = 1";
            }
            // Total number of books
            $totalBooks = $wpdb->get_results("SELECT * FROM {$tablePrefix}books_system {$isTracedCondition}", ARRAY_A);
            // Books on limits
            $books = $wpdb->get_results(
                "
        SELECT * FROM {$tablePrefix}books_system {$isTracedCondition}
        ORDER BY {$orderBy} {$order}
        LIMIT {$offset}, {$per_page}",
                ARRAY_A
            );

            $totalBooksItems = count($totalBooks);
        }
        // 0.5 -> 1, 0.2 -> 1
        $this->set_pagination_args(array(
            'total_items' => $totalBooksItems,
            'per_page' => $per_page,
            'total_pages' => ceil($totalBooksItems / $per_page)   // here ceil() function is used to round up to the nearest integer
        ));
        $this->items = $books;

    }


    //Returm column names
    function get_columns()
    {

        // Key => value
        // DB Table column key => Front-end table column headers
        $columns = array(
            'cb' => '<input type="checkbox" />',
            'id' => 'ID',
            'name' => 'Book Name',
            'author' => 'Author Name',
            'profile_image' => 'Profile Image',
            'book_price' => 'Book Price',
            'pub_date' => 'Publish Date',
            'store_name' => 'Store Name',
            'created_at' => 'Created At'
            // 'action' => 'Action'
        );
        return $columns;
    }

    // No data found
    public function no_items()
    {
        echo ('No books found here.');
    }

    // To display data
    public function column_default($singleBook, $col_name)
    {
        return isset($singleBook[$col_name]) ? '<span class="bms-'.$col_name.'">'.$singleBook[$col_name].'</span>' : 'N/A';
    }

    // Add shorting Icons
    public function get_shortable_columns()
    {
        $sortable_columns = array(
            'id' => array('id', true),
            'name' => array('name', true),
            'author' => array('author', true),
            'book_price' => array('book_price', true),
            // 'pub_date' => array('pub_date', true),
            // 'store_name' => array('store_name', true),
            // 'created_at' => array('created_at', true),
            // 'store_name' => array
        );
        return $sortable_columns;
    }

    // To display book name
    public function column_name__($singleBook)
    {
        return sprintf('<a href="?page=edit_book&id=%s">%s</a>', $singleBook['id'], $singleBook['name']);
    }

    // To display book price
    public function column_book_price__($singleBook)
    {
        return sprintf('Rs. %s', $singleBook['book_price']);
    }
    // To display profile image
    public function column_profile_image($singleBook)
    {
        // return sprintf('<img src="%s" alt="Book Image" width="80" height="50" />', $singleBook['profile_image']);
        // OR
        return '<img src="' . $singleBook['profile_image'] . '" height="50px" width="70px" />';
    }
    // To display action buttons
    public function column_action($singleBook)
    {
        return sprintf('<a href="?page=edit_book&id=%s">Edit</a>', $singleBook['id']);
    }

    // To display checkbox
    public function column_cb($singleBook)
    {
        return sprintf('<input type="checkbox" name="book_id[]" value="%s" />', $singleBook['id']);
    }

    // To display bulk actions dropdown option
    public function get_bulk_actions()
    {
        $currentAction = $this->current_action();
        $actions = [];
        if ($currentAction == 'show_all') {
            // return $actions;
        } elseif ($currentAction == 'show_published') {
            $actions = array(
                'edit' => 'Edit',
                'trash' => 'Move to trash'
            );
        } elseif ($currentAction == 'show_trash') {
            $actions = array(
                'restore' => 'Restore',
                'delete_permanent' => 'Delete Permanently'
            );
        } else {
            # code...
        }
        return $actions;
    }

    // To Add row Action Links:Method #1
    public function handle_row_actions__($item, $column_name, $primary)
    {
        $actions = [];

        if ($column_name == "name") {
            $actions["edit"] = "<a href='#'>Edit</a>";
            $actions["quick-edit"] = "<a href='#'>Quick Edit</a>";
            $actions["delete"] = "<a href='#'>Delete</a>";
            $actions["trash"] = "<a href='#'>Trash</a>";
            $actions["view"] = "<a href='#'>View</a>";
        }

        // return sprintf('%s', $this->row_actions($actions));
        // OR
        return $this->row_actions($actions);
    }

    // To Add row Action Links:Method #3
    public function handle_row_actions_bc($item, $column_name, $primary)
    {
        $actions = [];

        if ($column_name !== $primary) {
            return "";
        }
        $actions["edit"] = "<a href='#'>Edit</a>";
        $actions["quick-edit"] = "<a href='#'>Quick Edit</a>";
        $actions["delete"] = "<a href='#'>Delete</a>";
        $actions["trash"] = "<a href='#'>Trash</a>";
        $actions["view"] = "<a href='#'>View</a>";

        // return sprintf('%s', $this->row_actions($actions));
        // OR
        return $this->row_actions($actions);
    }

    //  To Add row Action Links:Method #2
    public function column_author($item)
    {
        $actions = [];
        $action = $this->current_action();
        if ($action == "show_all") {
            if ($item['is_trash'] == 0) {
                $actions["edit"] = "<a href='#'>Edit</a>";
                $actions["quick-edit"] = "<a href='#' class='btn-quick-edit'>Quick Edit</a>";
                $actions["delete"] = "<a href='#'>Delete</a>";
                $actions["trash"] = "<a onclick='return confirm(`Are you sure you want to trash this book?`)' href='admin.php?page=list-books&action=trash&book_id={$item['id']}'>Trash</a>";
                $actions["view"] = "<a href='#'>View</a>";
            } elseif ($item['is_trash'] == 1) {
                $actions["restore"] = "<a href='#'>Restore</a>";
                $actions["delete_permanent"] = "<span class='trash'><a href='#'>Delete Permanent</a></span>";
            }

        } elseif ($action == "show_published") {
            $actions["edit"] = "<a href='#'>Edit</a>";
            $actions["quick-edit"] = "<a href='#' class='btn-quick-edit'>Quick Edit</a>";
            $actions["delete"] = "<a href='#'>Delete</a>";
            $actions["trash"] = "<a onclick='return confirm(`Are you sure you want to trash this book?`)' href='admin.php?page=list-books&action=trash&book_id={$item['id']}'>Trash</a>";
            $actions["view"] = "<a href='#'>View</a>";

        } elseif ($action == "show_trash") {
            $actions["restore"] = "<a onclick='return confirm(`Are you sure you want to restore this book?`)' href='admin.php?page=list-books&action=restore&book_id={$item['id']}'>Restore</a>";
            $actions["delete_permanent"] = "<span class='trash'><a onclick='return confirm(`Are you sure you want to delete this book permanently?`)' href='admin.php?page=list-books&action=delete_permanent&book_id={$item['id']}'>Delete Permanent</a></span>";

        } else {
            $actions["edit"] = "<a href='admin.php?page=list-books&action=edit&book_id={$item['id']}'>Edit</a>";
            $actions["quick-edit"] = "<a href='#' class='btn-quick-edit'>Quick Edit</a>";
            $actions["delete"] = "<a href='#'>Delete</a>";
            $actions["trash"] = "<a onclick='return confirm(`Are you sure you want to trash this book?`)' href='admin.php?page=list-books&action=trash&book_id={$item['id']}'>Trash</a>";
            $actions["view"] = "<a href='admin.php?page=list-books&book_id=".$item['id']."&action=show'>View</a>";
        }
        // return sprintf($item["author"]." ". '%s', $this->row_actions($actions));
        // Or
        return sprintf('%1$s %2$s', '<span class="bms-book-author">'.$item["author"].'</span>', $this->row_actions($actions));
        // Or
        // return $item["author"]." ". $this->row_actions($actions);
    }

    // Handle row actions
    private function process_row_action($action_type)
    {
        global $wpdb;
        $tablePrefix = $wpdb->prefix;
        if ($action_type == "trash") {

            // echo "<pre>";
            // print_r($_REQUEST);
            // die;
            $book_ids = isset($_REQUEST['book_id']) ? $_REQUEST['book_id'] : "";

            if (is_array($book_ids)) {
                // It is bulk sction
                foreach ($book_ids as $book_id) {
                    // Update operation
                    $wpdb->update("{$tablePrefix}books_system", [
                        "is_trash" => 1
                    ], [
                        "id" => $book_id
                    ]);
                }
                ?>
                <script>
                    // window.location.href = "admin.php?page=list-books&message=book_trashed";
                    window.location.href = "<?php echo admin_url("admin.php?page=list-books") ?>";
                </script>
                <?php

            } else {
                // It is single action
                if (!empty($book_ids)) {
                    // Update Operation
                    $wpdb->update("{$tablePrefix}books_system", [
                        "is_trash" => 1
                    ], [
                        "id" => $book_ids
                    ]);
                    // return "Book Trashed Successfully";
                    // header("Location: admin.php?page=list-books&message=book_trashed");
                    ?>
                    <script>
                        // window.location.href = "admin.php?page=list-books&message=book_trashed";
                        window.location.href = "<?php echo admin_url("admin.php?page=list-books") ?>";
                    </script>
                    <?php
                }
            }
        }elseif ($action_type == "restore") {
            $book_id = isset($_REQUEST['book_id']) ? $_REQUEST['book_id'] : "";
            // Trash -> is_trash = 1
            // Published -> is_trash = 0

            // echo "<pre>";
            // print_r($_REQUEST);
            // die;

            if (is_array($book_id)) {
                // It is bulk sction
                foreach ($book_id as $id) {
                    // Update operation
                    $wpdb->update("{$tablePrefix}books_system", [
                        "is_trash" => 0
                    ], [
                        "id" => $id
                    ]);
                }
            } else {
                // It is single action
                if (!empty($book_id)) {
                    $wpdb->update("{$tablePrefix}books_system", [
                        "is_trash" => 0
                    ], [
                        "id" => $book_id
                    ]);
                }
            }
            ?>
            <script>
                window.location.href = "<?php echo admin_url("admin.php?page=list-books&action=show_trash") ?>";
            </script>
            <?php
        }elseif($action_type == "delete_permanent") {
            // echo "<pre>";
            // print_r($_REQUEST);
            // die;

            $book_id = isset($_REQUEST['book_id']) ? $_REQUEST['book_id'] : "";
            if(is_array($book_id)) {    // return true value
                // bulk action
                foreach ($book_id as $id) {
                    $wpdb->delete("{$tablePrefix}books_system", [
                        "id" => $id
                    ]);
                }
            }else {
                if (!empty($book_id)) {
                    $wpdb->delete("{$tablePrefix}books_system", [
                        "id" => $book_id
                    ]);
                }
            }
            ?>
            <script>
                window.location.href = "<?php echo admin_url("admin.php?page=list-books&action=show_trash") ?>";
            </script>
            <?php
        }
    }

    // To add status links
    public function extra_tablenav($position)
    {
        if ($position == "top") {
            global $wpdb;
            $tablePrefix = $wpdb->prefix;
            $actionType = $this->current_action();

            $status_links = array(
                "all" => count($wpdb->get_results("SELECT * FROM {$tablePrefix}books_system", ARRAY_A)),
                "published" => count($wpdb->get_results("SELECT * FROM {$tablePrefix}books_system WHERE is_trash = 0", ARRAY_A)),
                "draft" => 1,
                "trash" => count($wpdb->get_results("SELECT * FROM {$tablePrefix}books_system WHERE is_trash = 1", ARRAY_A))
            );

            echo "<div class='alignleft actions'>";
            echo "<ul class='subsubsub status-links'>";
            foreach ($status_links as $status => $count) {
                $currentClass = "";

                if ($actionType == "show_" . $status) {
                    $currentClass = "current";
                }

                echo '<li><a href="admin.php?page=list-books&action=show_' . $status . '" class="' . $currentClass . '">' . ucfirst($status) . ' (' . $count . ')' . '</a></li> | ';


                // $class = ($status == "all") ? "current" : "";
                // echo "<li class='$class'><a class='' href='admin.php?page=list-books&status=$status'>$status <span class='count'>($count)</span></a></li> | ";
            }
            echo "</ul>";

            echo "</div>";


        }
    }


}



?>