<?php

class BooksManagement
{
  private $message = "";

  public function __construct()
  {
	add_action('admin_menu', array($this, 'addBMSMenus'));

	// Add plugin script
	add_action('admin_enqueue_scripts', array($this, 'bmsEnqueueScripts'));

	// Add plugin style
	add_action('admin_enqueue_scripts', array($this, 'bmsEnqueueStyles'));

  }

  // Setup Menu and Submenus
  public function addBMSMenus()
  {
	add_menu_page('Books Management System', 'BM System', 'manage_options', 'books-system', array($this, 'addNewBookPage'), 'dashicons-book-alt', 6);
	add_submenu_page('books-system', 'Add New Book', 'Add New Book', 'manage_options', 'books-system', array($this, 'addNewBookPage'));
	add_submenu_page('books-system', 'Books List', 'Books List', 'manage_options', 'list-books', array($this, 'listBooksPage'));

  }

  public function addBooksSystemHandler()
  {
	echo '<h3 class="bms-h3">Books Management System</h3>';
  }
  // Add New Book Page
  public function addNewBookPage()
  {
	$this->addNewBook();
	$response = $this->message;

	// echo '<h3 class="bms-h3">Add New Book Page</h3>';
	ob_start();	//PHP Buffer start
	include_once BMS_PLUGIN_PATH . 'pages/add-books.php';	// content read
	$output = ob_get_contents();	// content storein variable
	ob_end_clean();	//PHP Buffer clean
	echo $output;		// content print

	// echo "<pre>";
	// print_r($output);
	// echo "</pre>;";

  }

private function addNewBook(){

	// echo '<pre>';
	// print_r($_REQUEST);
	// echo '</pre>';
	// die;

	//sanitize data
	global $wpdb;
	$table_prefix = $wpdb->prefix;
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@
$table_prefix = $wpdb->prefix; // wp_

        if( $_SERVER['REQUEST_METHOD'] == "POST" && isset($_REQUEST['btn_form_submit'])){

            // Sanitize
            $book_name = sanitize_text_field($_REQUEST['book_name']);
            $book_author = sanitize_text_field($_REQUEST['author_name']);
            $book_price = sanitize_text_field($_REQUEST['book_price']);
            $pub_date = sanitize_text_field($_REQUEST['pub_date']);
            $store_name = sanitize_text_field($_REQUEST['store_name']);
            $book_image = sanitize_text_field($_REQUEST['cover_image']);

            // Insert data
            $wpdb->insert("{$table_prefix}books_system", [
                "name" => $book_name,
                "author" => $book_author,
                "book_price" => $book_price,
                "pub_date" => $pub_date,
                "store_name" => $store_name,
                "profile_image" => $book_image
            ]);

            $book_id = $wpdb->insert_id;

            if($book_id > 0){

                $this->message = "Successfully, book has been created";
            }else{

                $this->message = "Failed to create book";
            }
        }
}

// Toread book details

private function getBookDetailsById($book_id){
global $wpdb;
	$table_prefix = $wpdb->prefix;
	$book_data = $wpdb->get_row("SELECT * FROM {$table_prefix}books_system WHERE id = {$book_id}", ARRAY_A);
	return $book_data;
}
// OR Insert data URL =>   https://www.youtube.com/watch?v=aIum0EPFBVs

// public function bmsListBooksHandler(){
public function listBooksPage()
  {
    // echo '<h3 class="bms-h3">List Books Page</h3>';
// echo "List Page 1";
global $wpdb;
$hasAsction = isset($_REQUEST['action']) ? $_REQUEST['action'] : "";
$hasBookId = isset($_REQUEST['book_id']) ? $_REQUEST['book_id'] : "";

// echo "<pre>";
// print_r($_REQUEST);

ob_start();	//PHP Buffer start
if($hasAsction == "show"){
$data = $this->getBookDetailsById($hasBookId);
  // echo "View Single book details page";
  include_once BMS_PLUGIN_PATH . 'pages/show-book.php';	// content read
}elseif($hasAsction == "edit"){
// print_r($_REQUEST);
  if($_SERVER['REQUEST_METHOD'] == "POST" ){
    $wpdb->update("{$wpdb->prefix}books_system", [
      "name" => sanitize_text_field($_REQUEST['book_name']),
      "author" => sanitize_text_field($_REQUEST['author_name']),
      "book_price" => sanitize_text_field($_REQUEST['book_price']),
      "pub_date" => sanitize_text_field($_REQUEST['pub_date']),
      "store_name" => sanitize_text_field($_REQUEST['store_name']),
      "profile_image" => sanitize_text_field($_REQUEST['cover_image'])
    ], [
      "id" =>$_REQUEST['book_id']
    ]);

    $response = "Successfully, book has been updated";

  }


  $data = $this->getBookDetailsById($hasBookId);	// echo "Edit book details page";
  include_once BMS_PLUGIN_PATH . 'pages/edit-book.php';
}else{
  include_once BMS_PLUGIN_PATH . 'pages/list-book.php';	// content read
}

$output = ob_get_contents();	// content storein variable
    ob_end_clean();	//PHP Buffer clean
    echo $output;		// content print

  }
  public function bmsCreateTable()
  {
	global $wpdb;
	$table_prefix = $wpdb->prefix;
	$tablesql = 'CREATE TABLE `' . $table_prefix . 'books_system` (
		`id` int(5) NOT NULL AUTO_INCREMENT,
		`name` varchar(120) NOT NULL,
		`author` varchar(120) NOT NULL,
		`profile_image` varchar(120) NOT NULL,
		`book_price` int(11) DEFAULT NULL,
        `pub_date` date DEFAULT NULL,
        `store_name`  varchar(120) NOT NULL,
        `is_trash` INT(5) NOT NULL DEFAULT "0",
		`created_at` timestamp NOT NULL DEFAULT current_timestamp(),
		PRIMARY KEY (`id`)
		) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4';
	include_once ABSPATH . 'wp-admin/includes/upgrade.php';

	dbDelta($tablesql);
  }

  // Drop table
  public function bmsDropTable()
  {
	global $wpdb;
	$table_prefix = $wpdb->prefix;
	// $wpdb->query('DROP TABLE IF EXISTS ' . $table_prefix . 'books_system');
	// or
	$tableDropMysql = "DROP TABLE IF EXISTS {$table_prefix}books_system";
	$wpdb->query($tableDropMysql);
  }


// Add plugin Script
  public function bmsEnqueueScripts()
  {
	// CSS
	wp_enqueue_style('bms-style', BMS_PLUGIN_URL . 'assets/css/style.css', array(), '1.0.0', 'all');
  wp_enqueue_style('bootstrap-style', BMS_PLUGIN_URL . 'assets/css/bootstrap.min.css', array(), '1.2.0', 'all');
	// JS
	wp_enqueue_media('');
	wp_enqueue_script('bms-validate-script', BMS_PLUGIN_URL . 'assets/js/jquery.validate.min.js', array('jquery'), '1.21.0', true);

	wp_enqueue_script('bms-script', BMS_PLUGIN_URL . 'assets/js/script.js', array('jquery'), '1.0.0', true);

  // To add inline js code
  $data = 'var bms_plugin_ajax_url="'.admin_url('admin-ajax.php').'"';
	wp_add_inline_script("bms-script", $data);

  }

public function bms_handle_ajax_request(){
  global $wpdb;
  $tablePrefix = $wpdb->prefix;
  $operation_type = isset($_REQUEST['param']) ? $_REQUEST['param'] : "";
  if($operation_type == 'save_quick_form'){
    $wpdb->update("{$tablePrefix}books_system", [
      "name" => sanitize_text_field($_REQUEST['name']),
      "author" => sanitize_text_field($_REQUEST['author']),
      "book_price" => sanitize_text_field($_REQUEST['cost']),

      // "author" => $_REQUEST['author_name'],
      // "pub_date" => sanitize_text_field($_REQUEST['pub_date']),
      // "store_name" => sanitize_text_field($_REQUEST['store_name']),
      // "profile_image" => sanitize_text_field($_REQUEST['cover_image'])

    ],[
      "id" => sanitize_text_field($_REQUEST['id'])
    ]);

    echo json_encode(array(
      "status" => "success",
      "message" => "Book has been updated successfully"
    ));
  }

wp_die();
}

// Add plugin Style
  public function bmsEnqueueStyles()
  {
	// wp_enqueue_style('bms-style', plugin_dir_url(__FILE__) . 'assets/css/style.css', array(), '1.0.0', 'all');
	// wp_enqueue_style('bms-style', BMS_PLUGIN_URL . 'assets/css/style.css', array(), '1.0.0', 'all');
  }


}